<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\OrderDetail;
use App\Models\OrderHeader;
use App\Http\Requests\OrderDetail\Index;
use App\Http\Requests\OrderDetail\Show;
use App\Http\Requests\OrderDetail\Create;
use App\Http\Requests\OrderDetail\Store;
use App\Http\Requests\OrderDetail\Edit;
use App\Http\Requests\OrderDetail\Update;
use App\Http\Requests\OrderDetail\Destroy;


/**
 * Description of OrderDetailController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class OrderDetailController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        return view('pages.order_detail.index', ['records' => OrderDetail::paginate(10)]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  OrderDetail  $orderdetail
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, OrderDetail $orderdetail)
    {
        return view('pages.order_detail.show', [
                'record' =>$orderdetail,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {
		$order_header = OrderHeader::all(['id']);

        return view('pages.order_detail.create', [
            'model' => new OrderDetail,
			"order_header" => $order_header,

        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new OrderDetail;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'OrderDetail saved successfully');
            return redirect()->route('order_detail.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving OrderDetail');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  OrderDetail  $orderdetail
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, OrderDetail $orderdetail)
    {
		$order_header = OrderHeader::all(['id']);

        return view('pages.order_detail.edit', [
            'model' => $orderdetail,
			"order_header" => $order_header,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  OrderDetail  $orderdetail
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,OrderDetail $orderdetail)
    {
        $orderdetail->fill($request->all());

        if ($orderdetail->save()) {
            
            session()->flash('app_message', 'OrderDetail successfully updated');
            return redirect()->route('order_detail.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating OrderDetail');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  OrderDetail  $orderdetail
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, OrderDetail $orderdetail)
    {
        if ($orderdetail->delete()) {
                session()->flash('app_message', 'OrderDetail successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting OrderDetail');
            }

        return redirect()->back();
    }
}
