<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\OrderHeader;
use App\Http\Requests\OrderHeader\Index;
use App\Http\Requests\OrderHeader\Show;
use App\Http\Requests\OrderHeader\Create;
use App\Http\Requests\OrderHeader\Store;
use App\Http\Requests\OrderHeader\Edit;
use App\Http\Requests\OrderHeader\Update;
use App\Http\Requests\OrderHeader\Destroy;


/**
 * Description of OrderHeaderController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class OrderHeaderController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        return view('pages.order_header.index', ['records' => OrderHeader::paginate(10)]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  OrderHeader  $order_header
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, OrderHeader $order_header)
    {
        // return $order_header;
        return view('pages.order_header.show', [
                'record' =>$order_header,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {

        return view('pages.order_header.create', [
            'model' => new OrderHeader,

        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new OrderHeader;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'OrderHeader saved successfully');
            return redirect()->route('order_header.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving OrderHeader');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  OrderHeader  $order_header
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, OrderHeader $order_header)
    {

        return view('pages.order_header.edit', [
            'model' => $order_header,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  OrderHeader  $order_header
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,OrderHeader $order_header)
    {
        $order_header->fill($request->all());

        if ($order_header->save()) {
            
            session()->flash('app_message', 'OrderHeader successfully updated');
            return redirect()->route('order_header.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating OrderHeader');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  OrderHeader  $order_header
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, OrderHeader $order_header)
    {
        if ($order_header->delete()) {
                session()->flash('app_message', 'OrderHeader successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting OrderHeader');
            }

        return redirect()->back();
    }
}
