<?php



namespace App\Http\Controllers;



use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Spatie\Permission\Models\Role;

use Spatie\Permission\Models\Permission;

use Illuminate\Support\Facades\DB;



class RoleController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    function __construct()

    {

    //        $this->middleware('permission:roles-listar|roles-crear|roles-editar|roles-eliminar', ['only' => ['index','store']]);
    //
    //        $this->middleware('permission:roles-crear', ['only' => ['create','store']]);
    //
    //        $this->middleware('permission:roles-editar', ['only' => ['edit','update']]);
    //
    //        $this->middleware('permission:roles-eliminar', ['only' => ['destroy']]);

    }



    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function index(Request $request)

    {
        //return $request;

        $records = Role::orderBy('id','DESC')->paginate(5);

        return view('pages.roles.index',compact('records'))

            ->with('i', ($request->input('page', 1) - 1) * 5);

    }



    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

        $permission = Permission::where("guard_name",'web')->orderBy('name','ASC')->get();

        return view('pages.roles.create',compact('permission'));

    }



    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        $this->validate($request, [

            'name' => 'required|unique:roles,name',

            'permission' => 'required',

        ]);



        $role = Role::create(['name' => $request->input('name')]);

        $role->syncPermissions($request->input('permission'));



        return redirect()->route('roles.index')

            ->with('success','Role created successfully');

    }

    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {

        $role = Role::find($id);

        $rolePermissions = Permission::join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")

            ->where("role_has_permissions.role_id",$id)
            ->orderBy('name','ASC')

            ->get();



        return view('pages.roles.show',compact('role','rolePermissions'));

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function edit($id)

    {

        $role = Role::find($id);

        $permission = Permission::where('guard_name',$role->guard_name)->orderBy('name','ASC')->get();

        $rolePermissions = DB::table("role_has_permissions")->where("role_has_permissions.role_id",$id)

            ->pluck('role_has_permissions.permission_id','role_has_permissions.permission_id')

            ->all();



        return view('pages.roles.edit',compact('role','permission','rolePermissions'));

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, $id)

    {

        $this->validate($request, [

            'name' => 'required',

            'permission' => 'required',

        ]);



        $role = Role::find($id);

        $role->name = $request->input('name');

        $role->save();



        $role->syncPermissions($request->input('permission'));



        return redirect()->route('roles.index')

            ->with('success','Rol actualizado exitosamente');

    }

    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)

    {

        DB::table("roles")->where('id',$id)->delete();

        return redirect()->route('pages.roles.index')

            ->with('success','Rol eliminado correctamente');

    }

}
