<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Warehouse;
use App\Http\Requests\Warehouses\Index;
use App\Http\Requests\Warehouses\Show;
use App\Http\Requests\Warehouses\Create;
use App\Http\Requests\Warehouses\Store;
use App\Http\Requests\Warehouses\Edit;
use App\Http\Requests\Warehouses\Update;
use App\Http\Requests\Warehouses\Destroy;


/**
 * Description of WarehouseController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class WarehouseController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        return view('pages.warehouses.index', ['records' => Warehouse::paginate(10)]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  Warehouse  $warehouse
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, Warehouse $warehouse)
    {
        return view('pages.warehouses.show', [
                'record' =>$warehouse,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {

        return view('pages.warehouses.create', [
            'model' => new Warehouse,

        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new Warehouse;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'Warehouse saved successfully');
            return redirect()->route('warehouses.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving Warehouse');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  Warehouse  $warehouse
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, Warehouse $warehouse)
    {

        return view('pages.warehouses.edit', [
            'model' => $warehouse,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  Warehouse  $warehouse
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,Warehouse $warehouse)
    {
        $warehouse->fill($request->all());

        if ($warehouse->save()) {
            
            session()->flash('app_message', 'Warehouse successfully updated');
            return redirect()->route('warehouses.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating Warehouse');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  Warehouse  $warehouse
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, Warehouse $warehouse)
    {
        if ($warehouse->delete()) {
                session()->flash('app_message', 'Warehouse successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting Warehouse');
            }

        return redirect()->back();
    }
}
