<?php

namespace App\Http\Requests\OrderDetail;

use Illuminate\Foundation\Http\FormRequest;

class Update extends FormRequest 
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize() 
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules() 
    {
        return [
			'order_header_id' => 'nullable|exists:order_header,id|numeric',
			'ItemCode' => 'nullable|max:50',
			'Quantity' => 'nullable|numeric',
			'UnitPrice' => 'nullable|numeric',
			'DiscountPercent' => 'nullable|numeric',
			'WarehouseCode' => 'nullable|max:8',
			'TaxCode' => 'nullable|max:8',
        ];
    }

    /**
    * Get the error messages for the defined validation rules.
    *
    * @return array
    */
    public function messages()
    {
        return [
     
        ];
    }

}
