<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
/**
   @property bigint $order_header_id order header id
@property varchar $ItemCode ItemCode
@property decimal $Quantity Quantity
@property decimal $UnitPrice UnitPrice
@property decimal $DiscountPercent DiscountPercent
@property varchar $WarehouseCode WarehouseCode
@property varchar $TaxCode TaxCode
@property timestamp $created_at created at
@property timestamp $updated_at updated at
@property OrderHeader $orderHeader belongsTo
   
 */
class OrderDetail extends Model 
{
    
    /**
    * Database table name
    */
    protected $table = 'order_detail';

    /**
    * Mass assignable columns
    */
    protected $fillable=['order_header_id',
'ItemCode',
'Quantity',
'UnitPrice',
'DiscountPercent',
'WarehouseCode',
'TaxCode'];

    /**
    * Date time columns.
    */
    protected $dates=[];

    /**
    * orderHeader
    *
    * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
    */
    public function orderHeader()
    {
        return $this->belongsTo(OrderHeader::class,'order_header_id');
    }

    public function product()
    {
        return $this->belongsTo(GteProducto::class,'ItemCode','PRODUCTO_ID');
    }





}