<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
/**
   @property int $Series Series
@property date $DocDate DocDate
@property date $TaxDate TaxDate
@property date $DocDueDate DocDueDate
@property varchar $CardCode CardCode
@property int $SalesPersonCode SalesPersonCode
@property varchar $Comments Comments
@property decimal $DiscountPercent DiscountPercent
@property varchar $DocType DocType
@property int $BPL_IDAssignedToInvoice BPL IDAssignedToInvoice
@property timestamp $created_at created at
@property timestamp $updated_at updated at
@property \Illuminate\Database\Eloquent\Collection $orderDetail hasMany
   
 */
class OrderHeader extends Model 
{
    
    /**
    * Database table name
    */
    protected $table = 'order_header';

    /**
    * Mass assignable columns
    */
    protected $fillable=['Series',
    'DocDate',
    'TaxDate',
    'DocDueDate',
    'CardCode',
    'CardName',
    'SalesPersonCode',
    'Comments',
    'DiscountPercent',
    'DocType',
    'BPL_IDAssignedToInvoice',
    'amount',
    'status',
    'source',
    'expected_amount',
    'new_client',
    ];

    /**
    * Date time columns.
    */
    protected $dates=['DocDate',
    'TaxDate',
    'DocDueDate',
    ];

    /**
    * orderDetails
    *
    * @return \Illuminate\Database\Eloquent\Relations\HasMany
    */
    public function orderDetails()
    {
        return $this->hasMany(OrderDetail::class,'order_header_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function warehouse()
    {
        return $this->belongsTo(GteBodega::class,'warehouse_id','BODEGA_ID');
    }

    public function client()
    {
        if($this->new_client){
            return $this->belongsTo(Client::class,'CardCode','CardCode');
        }else{
            return $this->belongsTo(GteCliente::class,'CardCode','CLIENTE_ID');
        }
    }

    public function activities()
    {
        return $this->hasMany(OrderActivity::class,'order_id');
    }

    public function getProgressAttribute()
    {
        $advanceTable = ['Cerrado sin facturar'=>'0%', 'Facturado'=>'100%', 'Cotizado'=>'25%', 'En negociacion'=>'50%'];
        
        return $this->status ? $advanceTable[$this->status] : 0;
    }

    public function getFollowupDateAttribute()
    {
        $followup_date = null;
        foreach ($this->activities as $activity) {
            if ($activity->followup_date) {
                $followup_date = $activity->followup_date;
            }
        }
        return $followup_date;
    }

    public function getMostExpensiveCategoryAttribute()
    {
        $mostExpensiveCategory = null;
        $mostExpensivePrice = 0;
        foreach ($this->orderDetails as $detail) {
            if ($detail->UnitPrice > $mostExpensivePrice) {
                $mostExpensivePrice = $detail->UnitPrice;
                // $product = GteProducto::where("PRODUCTO_ID",$detail->ItemCode)->first();
                // $linea = GteProductosLinea::where("LINEA_ID",$product->LINEA_ID)->first();
                $mostExpensiveCategory = $detail->product?->linea->DESCRIPCION;
            }
        }
        return $mostExpensiveCategory;
    }

    public function getManageStatus()
    {
        // $today = date('Y-m-d');
        // $followup_date = $this->getFollowupDateAttribute();

        $followup_date = Carbon::parse($this->getFollowupDateAttribute());
        $startDate = Carbon::parse($this->getFollowupDateAttribute())->subDays(2);
        $today = Carbon::now();

        // return $followup_date;

        
        if ($followup_date) {
            if ($today->gt($followup_date)) {
                return '<span class="badge bg-danger">Vencido</span>';
            } else if ($today->between($startDate, $followup_date)) {
                return '<span class="badge bg-warning">Por vencer</span>';;
            } else {
                return '<span class="badge bg-success">A tiempo</span>';;
            }
        } else {
            return '-';
        }
    }

    

}