<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

use Illuminate\Database\Eloquent\Model;
/**
   @property varchar $name name
@property varchar $email email
@property timestamp $email_verified_at email verified at
@property varchar $password password
@property varchar $remember_token remember token
@property timestamp $created_at created at
@property timestamp $updated_at updated at
@property varchar $document document
@property varchar $parent_document parent document
@property varchar $type type
@property varchar $address address
@property varchar $movile movile
@property varchar $phone phone
@property varchar $status status
@property varchar $genre genre
@property varchar $avatar avatar
@property date $birthday birthday
@property varchar $civil_status civil status
@property varchar $country country
@property varchar $province province
@property varchar $city city
@property varchar $bank bank
@property varchar $account_number account number
@property varchar $account_type account type
@property int $profile profile
@property varchar $leadership leadership
@property date $entry_date entry date
   
 */
class User extends Authenticatable
{

    use HasApiTokens, HasFactory, Notifiable, HasRoles;
    
    /**
    * Database table name
    */
    protected $table = 'users';

    /**
    * Mass assignable columns
    */
    protected $fillable=[
'name',
'email',
'password',
'document',
'parent_document',
'type',
'address',
'movile',
'phone',
'status',
'reason_status',
'genre',
'birthday',
'civil_status',
'country',
'province',
'canton',
'parish',
'bank',
'account_number',
'account_type',
'updated_by'

];

protected $hidden = [
    'password',
    'remember_token',
];

    /**
    * Date time columns.
    */
    protected $dates=['email_verified_at',
'birthday',
'entry_date'];

protected $casts = [
    'email_verified_at' => 'datetime',
    'password' => 'hashed',
];

    public function warehouses () {
        return $this->belongsToMany(GteBodega::class, 'users_warehouses', 'user_id', 'warehouse_id', 'id', 'BODEGA_ID');
    }


}