<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

     /*
     tabla de productos
     name
     type
     code
     make
     model
     measure
     price
     discount_percent
     details
     */

    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('code',50)->nullable();
            $table->string('name',50)->nullable();
            $table->string('type',50)->nullable();
            $table->string('make',50)->nullable();
            $table->string('model',50)->nullable();
            $table->string('measure',50)->nullable();
            $table->decimal('price',18,6)->nullable();
            $table->decimal('discount_percent',18,6)->nullable();
            $table->text('details',16)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product');
    }
};
