<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Laravel\Fortify\Fortify;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('document',13)->unique();
           
            $table->string('parent_document',13);
            $table->string('type',100)->nullable();
            $table->string('address')->nullable();
            $table->string('movile',50)->nullable();
            $table->string('phone',50)->nullable();
            $table->string('status',2)->default('A');
            $table->string('genre',2)->nullable();
            $table->string('avatar')->default('default.jpg');
            $table->date('birthday')->nullable();
            $table->string('civil_status',100)->nullable();
            $table->string('country',100)->nullable();
            $table->string('province',100)->nullable();
            $table->string('city',100)->nullable();
            $table->string('bank',100)->nullable();
            $table->string('account_number',100)->nullable();
            $table->string('account_type',50)->nullable();
            $table->integer('profile')->default(1);
            $table->string('leadership',100)->nullable();
            $table->date('entry_date')->nullable();
    });
}

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
           
        });
    }
};
