<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_header', function (Blueprint $table) {
            //
            $table->float('amount')->nullable();
            $table->string('status')->nullable();
            $table->string('source')->nullable();
            $table->float('expected_amount')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_header', function (Blueprint $table) {
            //
            $table->dropColumn('amount');
            $table->dropColumn('status');
            $table->dropColumn('source');
            $table->dropColumn('expected_amount');
        });
    }
};
