<form action="{{ isset($route) ? $route : url('storeorder') }}" method="POST">
    {{ csrf_field() }}
    <input type="hidden" name="_method" value="{{ isset($method) ? $method : 'POST' }}" />
    <div class="row">

        <fieldset class="row">
            <legend>Datos</legend>

        <div class="form-group col-5">
            <label for="CardCode">{{__('orders.CardCode')}}</label>
            <span class="form-control">{{ $client_code }}</span>
            <input type="hidden" name="CardCode" value="{{ $client_code }}" />

        </div>

        <div class="form-group col-5">
            <label for="CardName">{{__('orders.CardName')}}</label>
            <span class="form-control">{{ $client_name }}</span>
            <input type="hidden" name="CardName" value="{{ $client_name }}" />

        </div>
        <div class="form-group col-2">
            <label for="warehouse_id">{{__("orders.warehouse")}}</label>
            <select class="form-control {{ $errors->has('warehouse_id') ? ' is-invalid' : '' }} select2" name="warehouse_id"
                id="warehouse_id" value="{{ old('warehouse_id', $model->warehouse_id) }}" placeholder="" maxlength="15">
                @foreach ($warehouses as $wareshouse)
                    <option value="{{ $wareshouse->BODEGA_ID }}"
                        {{ $wareshouse->BODEGA_ID == $model->wareshouse_id ? 'selected' : '' }}>
                        {{ $wareshouse->DESCRIPCION }}</option>
                @endforeach

            </select>
            @if ($errors->has('warehouse_id'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('warehouse_id') }}</strong>
                </div>
            @endif
        </div>

        <input type="hidden" name="source" value="{{$source}}" />
        <input type="hidden" name="new_client" value="{{$new_client}}" />

        <div class="form-group col-10">
            <label for="Comments">{{__("orders.Comments")}}</label>
            <input type="text" class="form-control {{ $errors->has('Comments') ? ' is-invalid' : '' }}"
                name="Comments" id="Comments" value="{{ old('Comments', $model->Comments) }}" placeholder=""
                maxlength="254">
            @if ($errors->has('Comments'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('Comments') }}</strong>
                </div>
            @endif
        </div>

        <div class="form-group col-2">
            <label for="DiscountPercent">{{__("orders.DiscountPercent")}}</label>
            <input type="number" class="form-control {{ $errors->has('DiscountPercent') ? ' is-invalid' : '' }}"
                name="DiscountPercent" id="DiscountPercent"
                value="{{ old('DiscountPercent', $model->DiscountPercent) }}" placeholder="">
            @if ($errors->has('DiscountPercent'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('DiscountPercent') }}</strong>
                </div>
            @endif
        </div>
        </fieldset>


        <div class="form-group col-3">
            <label for="Type">{{__("orders.Type")}}</label>
            <select class="form-control {{ $errors->has('Type') ? ' is-invalid' : '' }} select2" name="Type"
                id="Type" value="{{ old('Type', $model->Type) }}" placeholder="" maxlength="1">
                <option value="">-- Seleccione Categoría --</option>
                @foreach ($types as $type)
                    <option value="{{ $type->type }}" {{ $type->type == $model->Type ? 'selected' : '' }}>
                        {{ $type->type }}</option>
                @endforeach
            </select>
        </div>
        
        <div class="form-group col-8">
            <label for="Product">{{__("orders.Product")}}</label>
            <select class="form-control {{ $errors->has('Product') ? ' is-invalid' : '' }} select2" name="Product"
                id="Product" value="{{ old('Product', $model->Product) }}" placeholder="" maxlength="1">
                @foreach ($products as $product)
                    <option value="{{ $product->code }}" {{ $product->code == $model->Product ? 'selected' : '' }}>
                        {{ $product->name }}</option>
                @endforeach
            </select>

        </div>



        {{-- <div class="form-group col-3">
            <label for="Make">Make</label>
            <select class="form-control {{ $errors->has('Make') ? ' is-invalid' : '' }} select2" name="Make"
                id="Make" value="{{ old('Make', $model->Make) }}" placeholder="" maxlength="1">
                <option value="I" {{ $model->Make == 'I' ? 'selected' : '' }}>I</option>
                <option value="S" {{ $model->Make == 'S' ? 'selected' : '' }}>S</option>
            </select>
        </div>


        <div class="form-group col-2">
            <label for="Model">Model</label>
            <select class="form-control {{ $errors->has('Model') ? ' is-invalid' : '' }} select2" name="Model"
                id="Model" value="{{ old('Model', $model->Model) }}" placeholder="" maxlength="1">
                <option value="I" {{ $model->Model == 'I' ? 'selected' : '' }}>I</option>
                <option value="S" {{ $model->Model == 'S' ? 'selected' : '' }}>S</option>
            </select>
        </div> --}}

        <div class="form-group col-1 p-3">
            <a class="btn btn-success" value="Add" id="AddProduct"> + </a>
        </div>


        <div class="form-group col-12">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>{{__("orders.Type")}}</th>
                        <th>{{__("orders.Code")}}</th>
                        {{-- <th>Make</th>
                        <th>Model</th>
                        <th>Measure</th> --}}
                        <th>{{__("orders.Quantity")}}</th>
                        <th>{{__("orders.Price")}}</th>
                        <th>{{__("orders.Discount")}}</th>
                        <th>{{__("orders.Total")}}</th>
                        <th>{{__("orders.Comments")}}</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>

        <div class="form-group col-12">
            <div class="float-end">
            <h3 id="total"></h3>
            </div>
        </div>


        <div class="form-group text-right ">
            <input type="submit" class="btn btn-primary" value="{{__('pages.save')}}" />

        </div>
    </div>
</form>
@push('custom-scripts')
    {{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script> --}}
    {{-- <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> --}}
    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.8/js/select2.min.js" defer></script> --}}
    <script type="module">
        $(document).ready(function() {
            let products = @json($products);

            let row_index = 0;

            // let order_details = [];


            $('.select2').select2({
                theme: "classic"
            });

            $('#Type').on('change', function() {
                var type = this.value;
                console.log($('#warehouse_id').val());
                $("#Make").html('');
                $.ajax({
                    url: "{{ url('productsbytype') }}",
                    type: "POST",
                    data: {
                        type: type,
                        warehouse_id: $('#warehouse_id').val(),
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#Make').html('<option value="">-- Seleccione Marca --</option>');
                        $.each(result.makes, function(key, value) {
                            $("#Make").append('<option value="' + value
                                .make + '">' + value.make + '</option>');
                        });
                        fillProducts(result.products);
                        $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
                    }
                });
            });

            
            //do the same for make

            // $('#Make').on('change', function() {
            //     var make = this.value;
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "{{ url('productsbymake') }}",
            //         type: "POST",
            //         data: {
            //             make: make,
            //             type: type,
            //             _token: '{{ csrf_token() }}'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
            //             $.each(result.models, function(key, value) {
            //                 $("#Model").append('<option value="' + value
            //                     .model + '">' + value.model + '</option>');
            //             });
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            // //do the same for model
            // $('#Model').on('change', function() {
            //     var model = this.value;
            //     var make = $('#Make').val();
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "{{ url('productsbymodel') }}",
            //         type: "POST",
            //         data: {
            //             model: model,
            //             make: make,
            //             type: type,
            //             _token: '{{ csrf_token() }}'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            function fillProducts(products) {
                $("#Product").html('');
                $.each(products, function(key, value) {
                    $("#Product").append('<option value="' + value
                        .code + '">' + value.name + '</option>');
                });
            }

            //listener for new element .deleteRow

            $(".deleteRow").click(function() {
                console.log('hello');
                var product_code = $(this).data("product_code");
                $('#' + product_code).remove();
            });

            //add product to table
            $("#AddProduct").click(function() {
                const product_code = $('#Product').val();
                
                if(!product_code) {
                    alert('Debe seleccionar un producto');
                    return;
                }
                
                const product = products.find(product => {
                    return product.code == product_code;
                });

                const productExists = $('#' + product.code + '_quantity').length > 0;

                if(productExists) {
                    console.log("🚀 ~ file: order.blade.php:258 ~ $ ~ productExists:", productExists);
                    const quantity = $('#' + product.code + '_quantity').val();
                    $('#' + product.code + '_quantity').val(parseInt(quantity) + 1);
                    //update total
                    const total = $('#' + product.code + '_total').text();
                    $('#' + product.code + '_total').text(parseFloat(total).toFixed(2) + parseFloat(product.price).toFixed(2));
                    calculateTotal();
                    return;
                }

                const row = '<tr id="' + product.code + '">' +
                    '<td>' + product.type +'</td>' +
                    '<td><input class="form-control" value=" ' + product.code +'" name="details[' + row_index + '][code]" readonly/></td>' +
                   
                    '<td><input id="'+ product.code +'_quantity" class="form-control" value="' + 1 + '" name="details[' + row_index + '][quantity]" type="number" onclick="updateQuantity(\'' + product.code + '\')"/></td>'+
                    '<td><input class="form-control" value=" ' + parseFloat(product.price) + '" name="details['+ row_index +'][price]" readonly/></td>'+
                    '<td>' + 0 + '</td>' +
                    '<td id="'+ product.code +'_total">' + parseFloat(product.price) + '</td>' +
                    '<td><input class="form-control" name="details[' + row_index + '][observations]" /> </td>'+
                    '<td><a class="btn btn-danger deleteRow"  product_code="' + product.code + '" onclick="deleteRow(\'' + product.code + '\')"> x </a></td>'+
                    '</tr>';
                $('tbody').append(row);


                row_index++;
                calculateTotal();
            });

            function calculateTotal() {
                var total = 0;
                var subtotalColumn = 5;
                $('tbody tr').each(function() {
                    var subtotal = $(this).find('td').eq(subtotalColumn).text();
                    total += parseFloat(subtotal);
                });
                $('#total').text(total);
            }

            const updateQuantity = function(product_code) {
                var product = products.find(product => {
                    return product.code == product_code;
                });
                const total = $('#' + product.code + '_total').text();
                const quantity = $('#' + product.code + '_quantity').val();

                $('#' + product.code + '_total').text( quantity * parseFloat(product.price));
                calculateTotal();
            }

            const deleteRow = function(product_code) {
                $('#' + product_code).remove();
            }

            window.updateQuantity = updateQuantity;
            window.deleteRow = deleteRow;
        });
    </script>
@endpush
