<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        span.select2.select2-container.select2-container--classic {
            width: 100% !important;
        }
    </style>
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
</head>

<body>
    <div id="app">
        {{-- <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
            <div class="container">
                <a class="navbar-brand" href="{{ url('/') }}">
                    {{ config('app.name', 'Laravel') }}
                </a> --}}
        {{-- @auth
                    @can('clients-manage')
                    <a class="navbar-brand" href="{{ route('clients.index') }}">
                        {{ __('pages.clients') }}
                    </a>
                    @endcan
                    @can('products-manage')
                    <a class="navbar-brand" href="{{ route('products.index') }}">
                        {{ __('pages.products') }}
                    </a>
                    @endcan
                    @can('preinvoices-manage')
                    <a class="navbar-brand" href="{{ route('orders.index') }}">
                        {{ __('pages.preinvoices') }}
                    </a>
                    @endcan
                    @can('preinvoices-create')
                    <a class="navbar-brand" href="{{ route('orders.create') }}">
                        {{ __('pages.create') }} {{ __('pages.preinvoices') }}
                    </a>
                    @endcan
                    @can('preinvoices-manage')
                    <a class="navbar-brand" href="{{ route('orders.create') }}">
                         {{ __('pages.manage') }} {{ __('pages.clients') }}
                    </a>
                    @endcan
                    @can('users-manage')
                    <a class="navbar-brand" href="{{ route('users.index') }}">
                        {{ __('pages.users') }}
                    </a>
                    @endcan
                    @can('partners-create')
                    <a class="navbar-brand" href="{{ route('partner_create') }}">
                        {{ __('pages.registerpartners') }}
                    </a>
                    @endcan
                    @can('tree-view')
                    <a class="navbar-brand" href="{{ route('tree') }}">
                        {{ __('pages.tree') }}
                    </a>
                    @endcan
                    @can('roles-manage')
                    <a class="navbar-brand" href="{{ route('roles.index') }}">
                        {{ __('pages.roles') }}
                    </a>
                    @endcan
                @endauth --}}
        {{-- <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav me-auto">

                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ms-auto">
                        <!-- Authentication Links -->
                        @guest
                            @if (Route::has('login'))
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('login') }}">{{ __('login.Login') }}</a>
                                </li>
                            @endif

                            @if (Route::has('register'))
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('register') }}">{{ __('login.Register') }}</a>
                                </li>
                            @endif
                        @else
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    {{ Auth::user()->name }}
                                </a>

                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="{{ route('logout') }}"
                                        onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        {{ __('login.Logout') }}
                                    </a>

                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
                                </div>
                            </li>
                        @endguest
                    </ul>
                </div>
            </div>
        </nav> --}}

        {{-- <div class="container-fluid"> --}}

        {{-- @yield('breadcrumb') --}}
        {{-- <div class="row flex-xl-nowrap flex-md-nowrap flex-sm-nowrap" style="min-height: calc(100vh - 97px)">
        <div class="col-sm-12 col-md-3 col-xl-2 bd-sidebar pl-0">

        <nav class="flex-column nav-pills" id="bd-docs-nav">
            <ul class="nav flex-column nav-pills">
                @can('clients-manage')
                <li class="nav-item">
                    <a class="nav-link" aria-current="page" href="{{ route('clients.index') }}">
                        {{ __('pages.clients') }}
                    </a>
                </li>
                @endcan
                @can('products-manage')
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('products.index') }}">
                        {{ __('pages.products') }}
                    </a>
                </li>
                @endcan
                @can('preinvoices-manage')
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('orders.order_client') }}">
                        {{ __('pages.manage') }} {{ __('pages.preinvoices') }}
                    </a>
                </li>
                @endcan
                @can('preinvoices-create')
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('orders.create') }}">
                        {{ __('pages.create') }} {{ __('pages.preinvoices') }}
                    </a>
                </li>
                @endcan
                @can('users-manage')
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('users.index') }}">
                        {{ __('pages.users') }}
                    </a>
                </li>
                @endcan
                @can('partners-create')
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('partner_create') }}">
                        {{ __('pages.registerpartners') }}
                    </a>
                </li>
                @endcan
                @can('tree-view')
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('tree') }}">
                        {{ __('pages.tree') }}
                    </a>
                </li>
                @endcan
                @can('roles-manage')
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('roles.index') }}">
                        {{ __('pages.roles') }}
                    </a>
                </li>
                @endcan
            </ul>
        </nav>

        </div> --}}
        <nav class="navbar bg-body-tertiary navbar-light bg-white shadow-sm">
            <div class="container-fluid">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>




                <!-- Authentication Links -->
                @guest
                    @if (Route::has('login'))
                        <a class="nav-link" href="{{ route('login') }}">{{ __('login.Login') }}</a>
                    @endif

                    {{-- @if (Route::has('register'))
                    
                        <a class="nav-link" href="{{ route('register') }}">{{ __('login.Register') }}</a>
                @endif --}}
                @else
                    <a class="nav-link" href="#" v-pre>
                        {{ Auth::user()->name }}
                    </a>
                    @foreach (Auth::user()->warehouses as $warehouse)
                        <span class="badge bg-secondary">{{ $warehouse->DESCRIPCION }}</span>
                    @endforeach

                @endguest

                <a class="navbar-brand" href="{{ url('/') }}">
                    <img src="{{ asset('images/logo-GTE-ok.png') }}" alt="" height="50"
                        class="d-inline-block align-text-top">
                    {{-- {{ config('app.name', 'Laravel') }} --}}
                </a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel">
                    <div class="offcanvas-header">
                        <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Menu</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                            aria-label="Close"></button>
                    </div>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            @can('mtlv-view')
                                <li class="nav-item">
                                    <a class="nav-link dropdown-toggle" href="#" id="mtlv" role="button" data-bs-toggle="dropdown" aria-expanded="false">

                                        {{ __('pages.mtlv') }}
                                    </a>
                                        <ul class="dropdown-menu" aria-labelledby="mtlv">
                                            @can('partners-create')
                                                <li class="nav-item">
                                                    <a class="nav-link" href="{{ route('partner_create') }}">
                                                        {{ __('pages.registerpartners') }}
                                                    </a>
                                                </li>
                                            @endcan

                                            @can('partners-view')
                                                <li class="nav-item">
                                                    <a class="nav-link" href="{{ route('partners') }}">
                                                        {{ __('pages.partners') }}
                                                    </a>
                                                </li>
                                            @endcan

                                            
                                            
                                        </ul>
                                </li>
                                @can('promos-view')
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('promos.index') }}">
                                        {{ __('pages.promos') }}
                                    </a>
                                </li>
                                @endcan
                            @endcan
                            @can('tree-view')
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('tree') }}">
                                        {{ __('pages.tree') }}
                                    </a>
                                </li>
                            @endcan
                            @can('admin-view')
                                <li class="nav-item">
                                    <a class="nav-link dropdown-toggle" href="#" id="admin" role="button" data-bs-toggle="dropdown" aria-expanded="false">

                                        {{ __('pages.admin') }}
                                    </a>
                                        <ul class="dropdown-menu" aria-labelledby="admin">
                                            @can('clients-manage')
                                                <li class="nav-item">
                                                    <a class="nav-link" aria-current="page" href="{{ route('clients.index') }}">
                                                        {{ __('pages.clients') }}
                                                    </a>
                                                </li>
                                            @endcan

                                            @can('users-manage')
                                                <li class="nav-item">
                                                    <a class="nav-link" href="{{ route('users.index') }}">
                                                        {{ __('pages.users') }}
                                                    </a>
                                                </li>
                                            @endcan
                                            
                                            @can('roles-manage')
                                                <li class="nav-item">
                                                    <a class="nav-link" href="{{ route('roles.index') }}">
                                                        {{ __('pages.roles') }}
                                                    </a>
                                                </li>
                                            @endcan
                                            @can('config-commissions-manage')
                                                <li class="nav-item">
                                                    <a class="nav-link" href="{{ route('config_commissions.index') }}">
                                                        {{ __('pages.config_commissions') }}
                                                    </a>
                                                </li>
                                            @endcan

                                            @can('admin-users-manage')
                                                <li class="nav-item">
                                                    <a class="nav-link" href="{{ route('users_manage') }}">
                                                        {{ __('pages.users_manage') }}
                                                    </a>
                                                </li>
                                            @endcan

                                            @can('admin-promos-manage')
                                                <li class="nav-item">
                                                    <a class="nav-link" href="{{ route('promos_manage') }}">
                                                        {{ __('pages.promos_manage') }}
                                                    </a>
                                                </li>
                                            @endcan
                                        </ul>
                                </li>
                            @endcan
                            
                            @can('products-manage')
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('products.index') }}">
                                        {{ __('pages.products') }}
                                    </a>
                                </li>
                            @endcan
                            @can('preinvoices-manage')
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('orders.order_client') }}">
                                        {{ __('pages.manage') }} {{ __('pages.preinvoices') }}
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('orders.order_client_history') }}">
                                        {{ __('pages.history') }} {{ __('pages.client') }}
                                    </a>
                                </li>
                            @endcan
                            @can('preinvoices-create')
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('clients.search') }}">
                                        {{ __('pages.create') }} {{ __('pages.preinvoices') }}
                                    </a>
                                </li>
                            @endcan
                            
                            

                            
                            {{-- <li class="nav-item dropdown">
                      <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Dropdown
                      </a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#">Action</a></li>
                        <li><a class="dropdown-item" href="#">Another action</a></li>
                        <li>
                          <hr class="dropdown-divider">
                        </li>
                        <li><a class="dropdown-item" href="#">Something else here</a></li>
                      </ul>
                    </li> --}}
                            <hr class="hr" />
                            <li class="nav-item">
                                <a class="dropdown-item" href="{{ route('logout') }}"
                                    onclick="event.preventDefault();
                                     document.getElementById('logout-form').submit();">
                                    {{ __('login.Logout') }}
                                </a>

                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
                        </ul>
                        {{-- <form class="d-flex mt-3" role="search">
                    <input class="form-control me-2" type="search" placeholder="Search" aria-label="Search">
                    <button class="btn btn-outline-success" type="submit">Search</button>
                  </form> --}}
                    </div>
                </div>
            </div>
        </nav>


        <main class="py-4">
            @yield('content')
        </main>
        {{-- </div>
    </div> --}}
    </div>
</body>
@yield('page-js-script')

{{-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script> --}}
<!-- Option 1: Bootstrap Bundle with Popper -->
{{-- @push('script') --}}
{{-- @endpush --}}
@stack('custom-scripts')

</html>
