@extends('layouts.app')
@section('breadcrumb')
<li class="breadcrumb-item">
    clients
</li>
@endsection
@section('header')
<h3><i class="fa fa-list"></i> clients </h3>
@endsection

@section('tools')
<a class="btn btn-secondary" href="{{route('clients.create')}}">
    {{-- <span class="fa fa-plus"></span> --}}
    + Agregar
</a>
@endsection
@section('content')
<div class="container">
    <div class='card'>
        <div class="card-header">{{ __('pages.clients') }}</div>
        <div class="card-body">
    <form action="{{ route('clients.index') }}" method="GET" class="mb-4">
        <div class="row">
        @csrf
            <div class="col-sm-4">
                <input type="text" name="search"
                class="form-control m-1"
                placeholder="{{ __('pages.search') }}..." />
            </div>
            <div class="col-sm-4">
                <button type="submit"
            class="btn btn-primary">{{ __('pages.search') }}</button>
            </div>
            <div class="col-sm-4">
                <a href="{{ route('clients.create') }}"
            class="btn btn-success">+ {{ __('pages.add') }}</a>
            </div>
        </div>
        
        
    </form>
    @include('tables.client')
    {{-- <div class="row">
        @foreach($records as $record)
        <div class="col-sm-6">
            @include('cards.client')
        </div>
        @endforeach
    </div> --}}
        </div>
</div>

</div>
<!-- create a modal to show client history -->
<div class="modal" id="historyModal" tabindex="-1" role="dialog" aria-labelledby="historyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
        {{-- <div class="modal-header">
            <h5 class="modal-title" id="historyModalLabel">Historial de cliente</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
            </button>
        </div> --}}
        <div class="modal-body">
            {{-- <p>Modal body text goes here.</p> --}}
        </div>
        {{-- <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            <button type="button" class="btn btn-primary">Save changes</button>
        </div> --}}
        </div>
    </div>
</div>
{!! $records->render() !!}
@endSection

@section('page-js-script')
<script type="text/javascript">
        $('document').ready(() =>{
        console.log('Hello testing');
        $('.history_btn').on('click', function(){
            console.log('Hello testing');
            $('#historyModal').modal('toggle');
            // let client_id = $(this).data('client_id');
            // console.log(client_id);
            // $.ajax({
            //     url: '/clients/'+client_id+'/history',
            //     type: 'GET',
            //     success: function(response){
            //         console.log(response);
            //         $('#historyModal').modal('show');
            //         $('#historyModal .modal-body').html(response);
            //     }
            // });
        });
    });
</script>
@endsection