@extends('layouts.app')
@section('breadcrumb')
    <li class="breadcrumb-item">
        <a href="{{ route('order_header.index') }}">order_header</a>
    </li>
    <li class="breadcrumb-item">
        {{ $record->id }}
    </li>
@endsection
@section('header')
    <h3><i class="fa fa-eye"></i> {{ $record->id }}</h3>
@endsection
@section('tools')
    <div class="btn-group">


    </div>
@endsection

@section('content')
    <div class="container">
        <div class="row">
            @if (session('app_error') || session('sap_message_error'))
                <div class="alert alert-warning">
                    {{ session('app_error') }} {{ session('sap_message_error') }}
                </div>
            @endif
            @if (session('app_message') || session('sap_message'))
                <div class="alert alert-success">
                    {{ session('app_message') }} {{ session('sap_message') }}
                </div>
            @endif
        </div>
        <div class='card'>
            <div class="card-header">{{ __('orders.manage') }}</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-4">
                        @include('cards.order.client')
                    </div>
                    <div class="col-8">
                        @include('cards.order.detail')
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card">
                        <div class="card-header">{{ __('orders.manage_client') }}</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-4">
                                    @include('forms.order_manage')
                                </div>
                                <div class="col-8">
                                    @include('forms.order_activity')
                                    <div class="mt-4">
                                        @include('tables.order_activity')
                                    </div>
                                    {{-- @include('cards.order.detail') --}}
                                </div>
                            </div>
                           
                            
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endSection
