@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-12 margin-tb">
                                <div class="pull-left">
                                    <h2>Gestión de Promociones</h2>
                                </div>
                                <div class="pull-right">
                                    @can('config-promos-create')
                                        <a class="btn btn-success" href="{{ route('promos.create') }}"> Crear nueva
                                            Promo</a>
                                    @endcan
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-body">
                        <div class="container">
                            @if ($message = Session::get('success'))
                                <div class="alert alert-success">
                                    <p>{{ $message }}</p>
                                </div>
                            @endif


                            <table class="table table-sm table-striped">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Nombre</th>

                                        <th>Estatus</th>
                                        <th width="280px">Acción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($promos as $key => $promo)
                                        <tr>
                                            <td>{{ $promo->name }}</td>
                                            <td>
                                                @if ($promo->status)
                                                    <span class="btn btn-success btn-sm" 
                                                        aria-hidden="true">Activo</span>
                                                @else
                                                    <span class="btn btn-secondary btn-sm" 
                                                        aria-hidden="true">Inactivo</span>
                                                @endif
                                            </td>
                                            <td>
                                                @can('admin-promos-edit')
                                                <form onsubmit="return confirm('Are you sure you want to change it?')"
                                                    action="{{route('promos.update',$promo->id)}}"
                                                    method="post"
                                                    style="display: inline">
                                                    {{csrf_field()}}
                                                    {{method_field('PUT')}}
                                                    <button type="submit" class="btn btn-info btn-sm m-1">
                                                        A/D
                                                    </button>
                                                </form>
                                                    {{-- {!! Form::open([
                                                        'method' => 'PUT',
                                                        'route' => ['promos.update', $promo->id],
                                                        'style' => 'display:inline',
                                                        'class' => '',
                                                    ]) !!}
                                                    {!! Form::submit('I/O', ['class' => 'btn btn-info btn-sm m-1']) !!}
                                                    {!! Form::close() !!} --}}
                                                @endcan
                                                @can('admin-promos-delete')
                                                <form onsubmit="return confirm('Are you sure you want to delete?')"
                                                    action="{{route('promos.destroy', $promo->id)}}"
                                                    method="post"
                                                    style="display: inline">
                                                    {{csrf_field()}}
                                                    {{method_field('DELETE')}}
                                                    <button type="submit" class="btn btn-danger btn-sm m-1">
                                                        Eliminar
                                                    </button>
                                                </form>
                                                    {{-- {!! Form::open([
                                                        'method' => 'DELETE',
                                                        'route' => ['promos.destroy', $promo->id],
                                                        'style' => 'display:inline',
                                                        'class' => 'delete',
                                                    ]) !!}
                                                    {!! Form::submit('X', ['class' => 'btn btn-danger btn-sm m-1']) !!}
                                                    {!! Form::close() !!} --}}
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        @endsection
