<form action="<?php echo e(isset($route) ? $route : url('storeorder')); ?>" method="POST">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="_method" value="<?php echo e(isset($method) ? $method : 'POST'); ?>" />
    <div class="row">

        <fieldset class="row">
            <legend>Datos</legend>

        <div class="form-group col-5">
            <label for="CardCode"><?php echo e(__('orders.CardCode')); ?></label>
            <span class="form-control"><?php echo e($client_code); ?></span>
            <input type="hidden" name="CardCode" value="<?php echo e($client_code); ?>" />

        </div>

        <div class="form-group col-5">
            <label for="CardName"><?php echo e(__('orders.CardName')); ?></label>
            <span class="form-control"><?php echo e($client_name); ?></span>
            <input type="hidden" name="CardName" value="<?php echo e($client_name); ?>" />

        </div>
        <div class="form-group col-2">
            <label for="warehouse_id"><?php echo e(__("orders.warehouse")); ?></label>
            <select class="form-control <?php echo e($errors->has('warehouse_id') ? ' is-invalid' : ''); ?> select2" name="warehouse_id"
                id="warehouse_id" value="<?php echo e(old('warehouse_id', $model->warehouse_id)); ?>" placeholder="" maxlength="15">
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wareshouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($wareshouse->BODEGA_ID); ?>"
                        <?php echo e($wareshouse->BODEGA_ID == $model->wareshouse_id ? 'selected' : ''); ?>>
                        <?php echo e($wareshouse->DESCRIPCION); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </select>
            <?php if($errors->has('warehouse_id')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('warehouse_id')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <input type="hidden" name="source" value="<?php echo e($source); ?>" />
        <input type="hidden" name="new_client" value="<?php echo e($new_client); ?>" />

        <div class="form-group col-10">
            <label for="Comments"><?php echo e(__("orders.Comments")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('Comments') ? ' is-invalid' : ''); ?>"
                name="Comments" id="Comments" value="<?php echo e(old('Comments', $model->Comments)); ?>" placeholder=""
                maxlength="254">
            <?php if($errors->has('Comments')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Comments')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-2">
            <label for="DiscountPercent"><?php echo e(__("orders.DiscountPercent")); ?></label>
            <input type="number" class="form-control <?php echo e($errors->has('DiscountPercent') ? ' is-invalid' : ''); ?>"
                name="DiscountPercent" id="DiscountPercent"
                value="<?php echo e(old('DiscountPercent', $model->DiscountPercent)); ?>" placeholder="">
            <?php if($errors->has('DiscountPercent')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('DiscountPercent')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
        </fieldset>


        <div class="form-group col-3">
            <label for="Type"><?php echo e(__("orders.Type")); ?></label>
            <select class="form-control <?php echo e($errors->has('Type') ? ' is-invalid' : ''); ?> select2" name="Type"
                id="Type" value="<?php echo e(old('Type', $model->Type)); ?>" placeholder="" maxlength="1">
                <option value="">-- Seleccione Categoría --</option>
                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($type->type); ?>" <?php echo e($type->type == $model->Type ? 'selected' : ''); ?>>
                        <?php echo e($type->type); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        
        <div class="form-group col-8">
            <label for="Product"><?php echo e(__("orders.Product")); ?></label>
            <select class="form-control <?php echo e($errors->has('Product') ? ' is-invalid' : ''); ?> select2" name="Product"
                id="Product" value="<?php echo e(old('Product', $model->Product)); ?>" placeholder="" maxlength="1">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($product->code); ?>" <?php echo e($product->code == $model->Product ? 'selected' : ''); ?>>
                        <?php echo e($product->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

        </div>



        

        <div class="form-group col-1 p-3">
            <a class="btn btn-success" value="Add" id="AddProduct"> + </a>
        </div>


        <div class="form-group col-12">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(__("orders.Type")); ?></th>
                        <th><?php echo e(__("orders.Code")); ?></th>
                        
                        <th><?php echo e(__("orders.Quantity")); ?></th>
                        <th><?php echo e(__("orders.Price")); ?></th>
                        <th><?php echo e(__("orders.Discount")); ?></th>
                        <th><?php echo e(__("orders.Total")); ?></th>
                        <th><?php echo e(__("orders.Comments")); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>

        <div class="form-group col-12">
            <div class="float-end">
            <h3 id="total"></h3>
            </div>
        </div>


        <div class="form-group text-right ">
            <input type="submit" class="btn btn-primary" value="<?php echo e(__('pages.save')); ?>" />

        </div>
    </div>
</form>
<?php $__env->startPush('custom-scripts'); ?>
    
    
    
    <script type="module">
        $(document).ready(function() {
            let products = <?php echo json_encode($products, 15, 512) ?>;

            let row_index = 0;

            // let order_details = [];


            $('.select2').select2({
                theme: "classic"
            });

            $('#Type').on('change', function() {
                var type = this.value;
                $("#Make").html('');
                $.ajax({
                    url: "<?php echo e(url('productsbytype')); ?>",
                    type: "POST",
                    data: {
                        type: type,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#Make').html('<option value="">-- Seleccione Marca --</option>');
                        $.each(result.makes, function(key, value) {
                            $("#Make").append('<option value="' + value
                                .make + '">' + value.make + '</option>');
                        });
                        fillProducts(result.products);
                        $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
                    }
                });
            });

            //do the same for make

            // $('#Make').on('change', function() {
            //     var make = this.value;
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "<?php echo e(url('productsbymake')); ?>",
            //         type: "POST",
            //         data: {
            //             make: make,
            //             type: type,
            //             _token: '<?php echo e(csrf_token()); ?>'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
            //             $.each(result.models, function(key, value) {
            //                 $("#Model").append('<option value="' + value
            //                     .model + '">' + value.model + '</option>');
            //             });
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            // //do the same for model
            // $('#Model').on('change', function() {
            //     var model = this.value;
            //     var make = $('#Make').val();
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "<?php echo e(url('productsbymodel')); ?>",
            //         type: "POST",
            //         data: {
            //             model: model,
            //             make: make,
            //             type: type,
            //             _token: '<?php echo e(csrf_token()); ?>'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            function fillProducts(products) {
                $("#Product").html('');
                $.each(products, function(key, value) {
                    $("#Product").append('<option value="' + value
                        .code + '">' + value.name + '</option>');
                });
            }

            //listener for new element .deleteRow

            $(".deleteRow").click(function() {
                console.log('hello');
                var product_code = $(this).data("product_code");
                $('#' + product_code).remove();
            });

            //add product to table
            $("#AddProduct").click(function() {
                const product_code = $('#Product').val();
                
                if(!product_code) {
                    alert('Debe seleccionar un producto');
                    return;
                }
                
                const product = products.find(product => {
                    return product.code == product_code;
                });

                const productExists = $('#' + product.code + '_quantity').length > 0;

                if(productExists) {
                    console.log("🚀 ~ file: order.blade.php:258 ~ $ ~ productExists:", productExists);
                    const quantity = $('#' + product.code + '_quantity').val();
                    $('#' + product.code + '_quantity').val(parseInt(quantity) + 1);
                    //update total
                    const total = $('#' + product.code + '_total').text();
                    $('#' + product.code + '_total').text(parseFloat(total).toFixed(2) + parseFloat(product.price).toFixed(2));
                    calculateTotal();
                    return;
                }

                const row = '<tr id="' + product.code + '">' +
                    '<td>' + product.type +'</td>' +
                    '<td><input class="form-control" value=" ' + product.code +'" name="details[' + row_index + '][code]" readonly/></td>' +
                   
                    '<td><input id="'+ product.code +'_quantity" class="form-control" value="' + 1 + '" name="details[' + row_index + '][quantity]" type="number" onclick="updateQuantity(\'' + product.code + '\')"/></td>'+
                    '<td><input class="form-control" value=" ' + parseFloat(product.price) + '" name="details['+ row_index +'][price]" readonly/></td>'+
                    '<td>' + 0 + '</td>' +
                    '<td id="'+ product.code +'_total">' + parseFloat(product.price) + '</td>' +
                    '<td><input class="form-control" name="details[' + row_index + '][observations]" /> </td>'+
                    '<td><a class="btn btn-danger deleteRow"  product_code="' + product.code + '" onclick="deleteRow(\'' + product.code + '\')"> x </a></td>'+
                    '</tr>';
                $('tbody').append(row);


                row_index++;
                calculateTotal();
            });

            function calculateTotal() {
                var total = 0;
                var subtotalColumn = 5;
                $('tbody tr').each(function() {
                    var subtotal = $(this).find('td').eq(subtotalColumn).text();
                    total += parseFloat(subtotal);
                });
                $('#total').text(total);
            }

            const updateQuantity = function(product_code) {
                var product = products.find(product => {
                    return product.code == product_code;
                });
                const total = $('#' + product.code + '_total').text();
                const quantity = $('#' + product.code + '_quantity').val();

                $('#' + product.code + '_total').text( quantity * parseFloat(product.price));
                calculateTotal();
            }

            const deleteRow = function(product_code) {
                $('#' + product_code).remove();
            }

            window.updateQuantity = updateQuantity;
            window.deleteRow = deleteRow;
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/b41wpxslh789/public_html/stagingsts/gte/resources/views/forms/order.blade.php ENDPATH**/ ?>