<form action="<?php echo e(isset($route) ? $route : route('clients.store')); ?>" method="POST">
    <?php echo e(csrf_field()); ?>


    <input type="hidden" name="goOrder" value="<?php echo e(isset($goOrder) ? $goOrder:false); ?>" />

    <fieldset class="row">
        <legend class="scheduler-border"><?php echo e(__('clients.GeneralInfo')); ?></legend>

        <div class="form-group col-md-6">
            <label for="U_HT_TIPO_ID"><?php echo e(__('clients.U_HT_TIPO_ID')); ?></label>
            <select class="form-control <?php echo e($errors->has('U_HT_TIPO_ID') ? ' is-invalid' : ''); ?>" name="U_HT_TIPO_ID"
                id="U_HT_TIPO_ID" value="<?php echo e(old('U_HT_TIPO_ID', $model->U_HT_TIPO_ID)); ?>" placeholder=""
                maxlength="2">
                <option value="">Seleccione</option>
                <option value="01">RUC</option>
                <option value="02">Cédula</option>
                <option value="03">Pasaporte</option>
            </select>
            <?php if($errors->has('U_HT_TIPO_ID')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('U_HT_TIPO_ID')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        
        

        <div class="form-group  col-md-6">
            <label for="document"><?php echo e(__('clients.document')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('document') ? ' is-invalid' : ''); ?>"
                name="document" id="document" value="<?php echo e(old('document', $model->document)); ?>" placeholder=""
                maxlength="15">
            <?php if($errors->has('document')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('document')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        <div class="form-group col-md-6">
            <label for="names"><?php echo e(__('clients.names')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('names') ? ' is-invalid' : ''); ?>"
                name="names" id="names" value="<?php echo e(old('names', $model->names)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('names')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('names')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-md-6">
            <label for="lastname"><?php echo e(__('clients.lastname')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('lastname') ? ' is-invalid' : ''); ?>"
                name="lastname" id="lastname" value="<?php echo e(old('lastname', $model->lastname)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('lastname')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('lastname')); ?></strong>
                </div>
            <?php endif; ?>
        </div>


        <div class="form-group col-md-6">
            <label for="U_HBT_TIPCONT"><?php echo e(__('clients.U_HBT_TIPCONT')); ?></label>
            <select class="form-control <?php echo e($errors->has('U_HBT_TIPCONT') ? ' is-invalid' : ''); ?>" name="U_HBT_TIPCONT"
                id="U_HBT_TIPCONT" value="<?php echo e(old('U_HBT_TIPCONT', $model->U_HBT_TIPCONT)); ?>" placeholder=""
                maxlength="2">
                <option value="">Seleccione</option>
                <option value="01">Persona Natural No Obligado a Llevar Contabilidad</option>
                <option value="02">Persona Natural Obligado a Llevar Contabilidad</option>
                <option value="03">Sociedad</option>
                <option value="04">Contribuyente Especial</option>
                <option value="05">Contribuyente Régimen Simplificado RISE</option>
                <option value="06">Otros</option>
                <option value="07">Servicios Profesionales</option>
            </select>
            <?php if($errors->has('U_HBT_TIPCONT')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('U_HBT_TIPCONT')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-md-6">
            <label for="GroupCode"><?php echo e(__('clients.GroupCode')); ?></label>
            <select class="form-control <?php echo e($errors->has('GroupCode') ? ' is-invalid' : ''); ?>" name="GroupCode"
                id="GroupCode" value="<?php echo e(old('GroupCode', $model->GroupCode)); ?>" placeholder="">
                <!--100=Consumido Final, 102=Subdisitrbuidor, 103=Flota, 104 Estado -->
                <option value="">Seleccione</option>
                <option value="100">Consumido Final</option>
                <option value="102">Subdisitrbuidor</option>
                <option value="103">Flota</option>
                <option value="104">Estado</option>
            </select>
            <?php if($errors->has('GroupCode')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('GroupCode')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-6">
            <label for="CmpPrivate"><?php echo e(__('clients.CmpPrivate')); ?></label>
            <select type="text" class="form-control <?php echo e($errors->has('CmpPrivate') ? ' is-invalid' : ''); ?>"
                name="CmpPrivate" id="CmpPrivate" value="<?php echo e(old('CmpPrivate', $model->CmpPrivate)); ?>"
                placeholder="">
                <!-- C=Company, E=Employee, G=Government, I=Private-->
                <option value="">Seleccione</option>
                <option value="C">Company</option>
                <option value="E">Employee</option>
                <option value="G">Government</option>
                <option value="I">Private</option>
            </select>
            <?php if($errors->has('CmpPrivate')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('CmpPrivate')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-6">
            <label for="Phone1"><?php echo e(__('clients.Phone1')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('Phone1') ? ' is-invalid' : ''); ?>"
                name="Phone1" id="Phone1" value="<?php echo e(old('Phone1', $model->Phone1)); ?>" placeholder=""
                maxlength="20">
            <?php if($errors->has('Phone1')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Phone1')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-6">
            <label for="Cellular"><?php echo e(__('clients.Cellular')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('Cellular') ? ' is-invalid' : ''); ?>"
                name="Cellular" id="Cellular" value="<?php echo e(old('Cellular', $model->Cellular)); ?>" placeholder=""
                maxlength="50">
            <?php if($errors->has('Cellular')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Cellular')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group  col-md-6">
            <label for="E_Mail"><?php echo e(__('clients.E_Mail')); ?></label>
            <input type="email" class="form-control <?php echo e($errors->has('E_Mail') ? ' is-invalid' : ''); ?>"
                name="E_Mail" id="E_Mail" value="<?php echo e(old('E_Mail', $model->E_Mail)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('E_Mail')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('E_Mail')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-md-6">
            <label for="GroupNum"><?php echo e(__('clients.GroupNum')); ?></label>
            <select class="form-control <?php echo e($errors->has('GroupNum') ? ' is-invalid' : ''); ?>" name="GroupNum"
                id="GroupNum" value="<?php echo e(old('GroupNum', $model->GroupNum)); ?>" placeholder="">
                <option value="">Seleccione</option>
                <option value="-1">Contado</option>
            </select>
            <?php if($errors->has('GroupNum')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('GroupNum')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        

    </fieldset>
    <fieldset class="row">
        <legend class="scheduler-border"><?php echo e(__('clients.Address')); ?></legend>


        <div class="form-group col-md-6">
            <label for="Address1"><?php echo e(__('clients.Address1')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('Address1') ? ' is-invalid' : ''); ?>"
                name="Address1" id="Address1" value="<?php echo e(old('Address1', $model->Address1)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('Address1')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Address1')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-md-6">
            <label for="Address2"><?php echo e(__('clients.Address2')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('Address2') ? ' is-invalid' : ''); ?>"
                name="Address2" id="Address2" value="<?php echo e(old('Address2', $model->Address2)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('Address2')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Address1')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-group col-md-6">
            <label for="Address3"><?php echo e(__('clients.Address3')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('Address3') ? ' is-invalid' : ''); ?>"
                name="Address3" id="Address3" value="<?php echo e(old('Address3', $model->Address3)); ?>" placeholder=""
                maxlength="100">
            <?php if($errors->has('Address3')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Address3')); ?></strong>
                </div>
            <?php endif; ?>
        </div>




        


        



        

        


        <div class="form-group text-right mt-4">
            
            <input type="submit" class="btn btn-primary" value="<?php echo e(__("pages.save")); ?>" />

        </div>
    </fieldset>
</form>
<?php /**PATH /home2/servercw/public_html/sts/gte/resources/views/forms/client.blade.php ENDPATH**/ ?>