<form action="<?php echo e(isset($route) ? $route : url('storeorder')); ?>" method="POST">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="_method" value="<?php echo e(isset($method) ? $method : 'POST'); ?>" />
    <input type="hidden" name="id" value="<?php echo e($model->id); ?>" />
    <div class="row">

        <fieldset class="row">
            <legend>Datos</legend>

        <div class="form-group col-4">
            <label for="CardCode"><?php echo e(__('orders.CardCode')); ?></label>
            <span class="form-control"><?php echo e($client_code ?? $model->CardCode); ?></span>
            <input type="hidden" name="CardCode" value="<?php echo e($client_code ?? $model->CardCode); ?>" />

        </div>

        <div class="form-group col-4">
            <label for="CardName"><?php echo e(__('orders.CardName')); ?></label>
            <span class="form-control"><?php echo e($client_name ?? $model->CardName); ?></span>
            <input type="hidden" name="CardName" value="<?php echo e($client_name ?? $model->CardName); ?>" />

        </div>
        

        <input type="hidden" name="source" value="<?php echo e($source); ?>" />
        <input type="hidden" name="new_client" value="<?php echo e(isset($new_client) ? $new_client : (isset($model->new_client)?$model->new_client:false)); ?>" />

        <div class="form-group col-4">
            <label for="Comments"><?php echo e(__("orders.Comments")); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('Comments') ? ' is-invalid' : ''); ?>"
                name="Comments" id="Comments" value="<?php echo e(old('Comments', $model->Comments)); ?>" placeholder=""
                maxlength="254">
            <?php if($errors->has('Comments')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('Comments')); ?></strong>
                </div>
            <?php endif; ?>
        </div>

        </fieldset>


        

        <div class="form-group col-3">
            <label for="warehouse_id"><?php echo e(__("orders.warehouse")); ?></label>
            <select class="form-control <?php echo e($errors->has('warehouse_id') ? ' is-invalid' : ''); ?> select2" name="warehouse_id"
                id="warehouse_id" value="<?php echo e(old('warehouse_id', $model->warehouse_id)); ?>" placeholder="" maxlength="15">
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wareshouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($wareshouse->BODEGA_ID); ?>"
                        <?php echo e($wareshouse->BODEGA_ID == $model->wareshouse_id ? 'selected' : ''); ?>>
                        <?php echo e($wareshouse->DESCRIPCION); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </select>
            <?php if($errors->has('warehouse_id')): ?>
                <div class="invalid-feedback">
                    <strong><?php echo e($errors->first('warehouse_id')); ?></strong>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="form-group col-8">
            <label for="Product"><?php echo e(__("orders.Product")); ?></label>
            <select class="form-control <?php echo e($errors->has('Product') ? ' is-invalid' : ''); ?> select2" name="Product"
                id="Product" value="<?php echo e(old('Product', $model->Product)); ?>" placeholder="" maxlength="1">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($product->code); ?>" <?php echo e($product->code == $model->Product ? 'selected' : ''); ?>>
                        <?php echo e($product->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

        </div>



        

        <div class="form-group col-1 p-3">
            <a class="btn btn-success" value="Add" id="AddProduct"> + </a>
        </div>


        <div class="form-group col-12">
            <table class="table table-striped table-hover" id="productsDetail">
                <thead>
                    <tr>
                        <th><?php echo e(__("orders.Type")); ?></th>
                        <th><?php echo e(__("orders.Code")); ?></th>
                        
                        <th><?php echo e(__("orders.Quantity")); ?></th>
                        <th><?php echo e(__("orders.Price")); ?></th>
                        <th><?php echo e(__("orders.Discount")); ?></th>
                        <th><?php echo e(__("orders.Total")); ?></th>
                        <th><?php echo e(__("orders.Comments")); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    

                </tbody>
            </table>
        </div>

        <div class="form-group col-12">
            <div class="float-end">
                <table>
                    <tr>
                        <td>Descuento: </td>
                        <td> <h4 id="discount"></h4></td>
                    </tr>
                    <tr>
                        <td>Subtotal: </td>
                        <td> <h4 id="subtotal"></h4></td>
                    </tr>
                    <tr>
                        <td>Iva 15%: </td>
                        <td> <h4 id="iva"></h4></td>
                    </tr>
                    <tr>
                        <td>Total: </td>
                        <td> <h4 id="total"></h3></td>
                    </tr>
                </table>
            </div>
        </div>


        <div class="form-group text-right ">
            <input type="submit" class="btn btn-primary" value="<?php echo e(__('pages.save')); ?>" />

        </div>
    </div>
</form>
<?php $__env->startPush('custom-scripts'); ?>
    
    
    
    <script type="module">
        $(document).ready(function() {
            let products = <?php echo json_encode($products, 15, 512) ?>;

            let detail_products = <?php echo json_encode($model->orderDetails, 15, 512) ?>;

            let row_index = 0;

            // let order_details = [];


            $('.select2').select2({
                theme: "classic"
            });

            // $('#Type').on('change', function() {
            //     var type = this.value;
            //     $("#Make").html('');
            //     $.ajax({
            //         url: "<?php echo e(url('productsbytype')); ?>",
            //         type: "POST",
            //         data: {
            //             type: type,
            //             warehouse_id: $('#warehouse_id').val(),
            //             _token: '<?php echo e(csrf_token()); ?>'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             $('#Make').html('<option value="">-- Seleccione Marca --</option>');
            //             $.each(result.makes, function(key, value) {
            //                 $("#Make").append('<option value="' + value
            //                     .make + '">' + value.make + '</option>');
            //             });
            //             fillProducts(result.products);
            //             $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
            //         }
            //     });
            // });

            $('#warehouse_id').on('change', function() {
                var warehouse_id = this.value;
                // var type = $('#Type').val();
                $.ajax({
                    url: "<?php echo e(url('productsbysearch')); ?>",
                    type: "POST",
                    data: {
                        // type: type,
                        warehouse_id: warehouse_id,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#Make').html('<option value="">-- Seleccione Marca --</option>');
                        $.each(result.makes, function(key, value) {
                            $("#Make").append('<option value="' + value
                                .make + '">' + value.make + '</option>');
                        });
                        fillProducts(result.products);
                        $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
                    }
                });
            });

            //do the same for make

            // $('#Make').on('change', function() {
            //     var make = this.value;
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "<?php echo e(url('productsbymake')); ?>",
            //         type: "POST",
            //         data: {
            //             make: make,
            //             type: type,
            //             _token: '<?php echo e(csrf_token()); ?>'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             $('#Model').html('<option value="">-- Seleccione Modelo --</option>');
            //             $.each(result.models, function(key, value) {
            //                 $("#Model").append('<option value="' + value
            //                     .model + '">' + value.model + '</option>');
            //             });
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            // //do the same for model
            // $('#Model').on('change', function() {
            //     var model = this.value;
            //     var make = $('#Make').val();
            //     var type = $('#Type').val();
            //     $.ajax({
            //         url: "<?php echo e(url('productsbymodel')); ?>",
            //         type: "POST",
            //         data: {
            //             model: model,
            //             make: make,
            //             type: type,
            //             _token: '<?php echo e(csrf_token()); ?>'
            //         },
            //         dataType: 'json',
            //         success: function(result) {
            //             fillProducts(result.products);
            //         }
            //     });
            // });

            console.log('detail_products', detail_products);

            if ( detail_products && detail_products.length > 0) {
                for (let i = 0; i < detail_products.length; i++) {
                    const detail = detail_products[i];
                    const product = products.find(product => {
                        return product.PRODUCTO_ID == detail.ItemCode;
                    });
                    rawProducto(product,detail.Quantity,detail.DiscountPercent);
                }
                calculateTotal();
            }

            

            function fillProducts(products) {
                $("#Product").html('');
                //if no products found alert the user
                if (products.length == 0) {
                    alert('No hay productos disponibles para esta categoría en esta bodega');
                    return;
                }
                $.each(products, function(key, value) {
                    $("#Product").append('<option value="' + value
                        .PRODUCTO_ID + '">' + value.NOMBRE_PRODUCTO + '</option>');
                });
            }

            //listener for new element .deleteRow

            $(".deleteRow").click(function() {
                console.log('hello');
                var product_code = $(this).data("product_code");
                $('#' + product_code).remove();
            });

            //add product to table
            $("#AddProduct").click(function() {
                const product_code = $('#Product').val();
                
                if(!product_code) {
                    alert('Debe seleccionar un producto');
                    return;
                }
                
                const product = products.find(product => {
                    return product.PRODUCTO_ID == product_code;
                });

                const productID = product.PRODUCTO_ID.replace(/\s/g, '');

                const productExists = $('#' + productID + '_quantity').length > 0;

                if(productExists) {
                    console.log("🚀 ~ file: order.blade.php:258 ~ $ ~ productExists:", productExists);
                    const quantity = $('#' + productID + '_quantity').val();
                    $('#' + productID + '_quantity').val(parseInt(quantity) + 1);
                    // //update total
                    updateProduct(product.PRODUCTO_ID);
                    // const total = $('#' + product.PRODUCTO_ID + '_total').text();
                    // $('#' + product.PRODUCTO_ID + '_total').text(parseFloat(total).toFixed(2) + parseFloat(product.VALOR_PRODUCTO).toFixed(2));
                    // calculateTotal();
                    return;
                }
                rawProducto(product);
                calculateTotal();
            });

            function rawProducto(product,quantity = 1,discount = 0){
                const productID = product.PRODUCTO_ID.replace(/\s/g, '');
                const discountTotal = parseFloat(product.VALOR_PRODUCTO) * quantity * (discount / 100);
                const amount = parseFloat((product.VALOR_PRODUCTO * quantity) - discountTotal).toFixed(2);
                const row = '<tr id="' + productID + '">' +
                    '<td>' + product.DESCRIPCION +'</td>' +
                    '<td><input class="form-control" value=" ' + product.PRODUCTO_ID +'" name="details[' + row_index + '][code]" readonly/></td>' +
                   
                    '<td><input id="'+ productID +'_quantity" class="form-control" value="' + quantity + '" name="details[' + row_index + '][quantity]" type="number" step="1" onclick="updateProduct(\'' + product.PRODUCTO_ID + '\')"/></td>'+
                    '<td><input class="form-control" value=" ' + parseFloat(product.VALOR_PRODUCTO) + '" name="details['+ row_index +'][price]" readonly/></td>'+
                    '<td><input id="'+ productID +'_discount" class="form-control" value="' + discount + '" name="details[' + row_index + '][discount]" type="number" step="1" onclick="updateProduct(\'' + product.PRODUCTO_ID + '\')"/></td>'+
                    '<td id="'+ productID +'_total">' + amount + '</td>' +
                    '<td><input class="form-control" name="details[' + row_index + '][observations]" /> </td>'+
                    '<td><a class="btn btn-danger deleteRow"  product_code="' + productID + '" onclick="deleteRow(\'' + productID + '\')"> x </a></td>'+
                    '</tr>';
                $('#productsDetail tbody').append(row);
                row_index++;
                // calculateTotal();
            }

            function calculateTotal() {
                const iva = 0.15;
                let total = 0;
                let totalDiscount = 0;
                const subtotalColumn = 5;
                const discountColumn = 4;
                const quantityColumn = 2;
                const priceColumn = 3;
                $('#productsDetail tbody tr').each(function() {
                    const subtotal = $(this).find('td').eq(subtotalColumn).text();
                    const price = $(this).find('td').eq(priceColumn).find('input').val();
                    total += parseFloat(subtotal);
                    const quantity = $(this).find('td').eq(quantityColumn).find('input').val();
                    const discount = $(this).find('td').eq(discountColumn).find('input').val();
                    const productDiscount = quantity * price * (discount / 100);
                    totalDiscount += parseFloat(productDiscount);

                });
                $('#discount').text(totalDiscount.toFixed(2));
                $('#subtotal').text(total.toFixed(2));
                $('#iva').text(parseFloat(total * iva).toFixed(2));
                $('#total').text(parseFloat(total + (total * iva), 2).toFixed(2));
            }


            const updateProduct = function(product_code) {
                var product = products.find(product => {
                    return product.PRODUCTO_ID == product_code;
                });
                const productID = product.PRODUCTO_ID.replace(/\s/g, '');
                const total = $('#' + productID + '_total').text();
                const quantity = $('#' + productID + '_quantity').val();
                const discount = $('#' + productID + '_discount').val();

                const totalDiscount = quantity * parseFloat(product.VALOR_PRODUCTO) * (discount / 100);

                $('#' + productID + '_total').text( (quantity * parseFloat(product.VALOR_PRODUCTO) - totalDiscount ).toFixed(2));
                calculateTotal();
            }


            const deleteRow = function(product_code) {
                $('#' + product_code).remove();
            }

            $('#warehouse_id').trigger('change');

            window.updateProduct = updateProduct;
            window.deleteRow = deleteRow;
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home2/servercw/public_html/sts/gte/resources/views/forms/order-history.blade.php ENDPATH**/ ?>