<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        span.select2.select2-container.select2-container--classic {
            width: 100% !important;
        }
    </style>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
</head>

<body>
    <div id="app">
        
        
        

        

        
        
        <nav class="navbar bg-body-tertiary navbar-light bg-white shadow-sm">
            <div class="container-fluid">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>




                <!-- Authentication Links -->
                <?php if(auth()->guard()->guest()): ?>
                    <?php if(Route::has('login')): ?>
                        <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('login.Login')); ?></a>
                    <?php endif; ?>

                    
                <?php else: ?>
                    <a class="nav-link" href="#" v-pre>
                        <?php echo e(Auth::user()->name); ?>

                    </a>
                    <?php $__currentLoopData = Auth::user()->warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="badge bg-secondary"><?php echo e($warehouse->DESCRIPCION); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php endif; ?>

                <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                    <img src="<?php echo e(asset('images/logo-GTE-ok.png')); ?>" alt="" height="50"
                        class="d-inline-block align-text-top">
                    
                </a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel">
                    <div class="offcanvas-header">
                        <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Menu</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                            aria-label="Close"></button>
                    </div>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mtlv-view')): ?>
                                <li class="nav-item">
                                    <a class="nav-link dropdown-toggle" href="#" id="mtlv" role="button" data-bs-toggle="dropdown" aria-expanded="false">

                                        <?php echo e(__('pages.mtlv')); ?>

                                    </a>
                                        <ul class="dropdown-menu" aria-labelledby="mtlv">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('partners-create')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="<?php echo e(route('partner_create')); ?>">
                                                        <?php echo e(__('pages.registerpartners')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('partners-view')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="<?php echo e(route('partners')); ?>">
                                                        <?php echo e(__('pages.partners')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            
                                            
                                        </ul>
                                </li>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('promos-view')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('promos.index')); ?>">
                                        <?php echo e(__('pages.promos')); ?>

                                    </a>
                                </li>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tree-view')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('tree')); ?>">
                                        <?php echo e(__('pages.tree')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin-view')): ?>
                                <li class="nav-item">
                                    <a class="nav-link dropdown-toggle" href="#" id="admin" role="button" data-bs-toggle="dropdown" aria-expanded="false">

                                        <?php echo e(__('pages.admin')); ?>

                                    </a>
                                        <ul class="dropdown-menu" aria-labelledby="admin">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clients-manage')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" aria-current="page" href="<?php echo e(route('clients.index')); ?>">
                                                        <?php echo e(__('pages.clients')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users-manage')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="<?php echo e(route('users.index')); ?>">
                                                        <?php echo e(__('pages.users')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                            
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles-manage')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="<?php echo e(route('roles.index')); ?>">
                                                        <?php echo e(__('pages.roles')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config-commissions-manage')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="<?php echo e(route('config_commissions.index')); ?>">
                                                        <?php echo e(__('pages.config_commissions')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin-users-manage')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="<?php echo e(route('users_manage')); ?>">
                                                        <?php echo e(__('pages.users_manage')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin-promos-manage')): ?>
                                                <li class="nav-item">
                                                    <a class="nav-link" href="<?php echo e(route('promos_manage')); ?>">
                                                        <?php echo e(__('pages.promos_manage')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                </li>
                            <?php endif; ?>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products-manage')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('products.index')); ?>">
                                        <?php echo e(__('pages.products')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('preinvoices-manage')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('orders.order_client')); ?>">
                                        <?php echo e(__('pages.manage')); ?> <?php echo e(__('pages.preinvoices')); ?>

                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('orders.order_client_history')); ?>">
                                        <?php echo e(__('pages.history')); ?> <?php echo e(__('pages.client')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('preinvoices-create')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('clients.search')); ?>">
                                        <?php echo e(__('pages.create')); ?> <?php echo e(__('pages.preinvoices')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            

                            
                            
                            <hr class="hr" />
                            <li class="nav-item">
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                    onclick="event.preventDefault();
                                     document.getElementById('logout-form').submit();">
                                    <?php echo e(__('login.Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                        </ul>
                        
                    </div>
                </div>
            </div>
        </nav>


        <main class="py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
        
    </div>
</body>
<?php echo $__env->yieldContent('page-js-script'); ?>


<!-- Option 1: Bootstrap Bundle with Popper -->


<?php echo $__env->yieldPushContent('custom-scripts'); ?>

</html>
<?php /**PATH /home2/servercw/public_html/sts/gte/resources/views/layouts/app.blade.php ENDPATH**/ ?>