<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-12 margin-tb">
                                <div class="pull-left">
                                    <h2>Gestión de Promociones</h2>
                                </div>
                                <div class="pull-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config-promos-create')): ?>
                                        <a class="btn btn-success" href="<?php echo e(route('promos.create')); ?>"> Crear nueva
                                            Promo</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="card-body">
                        <div class="container">
                            <?php if($message = Session::get('success')): ?>
                                <div class="alert alert-success">
                                    <p><?php echo e($message); ?></p>
                                </div>
                            <?php endif; ?>


                            <table class="table table-sm table-striped">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Nombre</th>

                                        <th>Estatus</th>
                                        <th width="280px">Acción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $promos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $promo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($promo->name); ?></td>
                                            <td>
                                                <?php if($promo->status): ?>
                                                    <span class="btn btn-success btn-sm" 
                                                        aria-hidden="true">Activo</span>
                                                <?php else: ?>
                                                    <span class="btn btn-secondary btn-sm" 
                                                        aria-hidden="true">Inactivo</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin-promos-edit')): ?>
                                                <form onsubmit="return confirm('Are you sure you want to change it?')"
                                                    action="<?php echo e(route('promos.update',$promo->id)); ?>"
                                                    method="post"
                                                    style="display: inline">
                                                    <?php echo e(csrf_field()); ?>

                                                    <?php echo e(method_field('PUT')); ?>

                                                    <button type="submit" class="btn btn-info btn-sm m-1">
                                                        A/D
                                                    </button>
                                                </form>
                                                    
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin-promos-delete')): ?>
                                                <form onsubmit="return confirm('Are you sure you want to delete?')"
                                                    action="<?php echo e(route('promos.destroy', $promo->id)); ?>"
                                                    method="post"
                                                    style="display: inline">
                                                    <?php echo e(csrf_field()); ?>

                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <button type="submit" class="btn btn-danger btn-sm m-1">
                                                        Eliminar
                                                    </button>
                                                </form>
                                                    
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/servercw/public_html/sts/gte/resources/views/pages/promos/index_manage.blade.php ENDPATH**/ ?>